// سكريبت المحتوى للتعامل مع صفحات Google Forms
(function() {
    'use strict';
    
    // إضافة الستايل المخصص للإضافة
    const style = document.createElement('style');
    style.textContent = `
        .hamiz-entry-extractor-highlight {
            outline: 2px solid #006837 !important;
            background-color: rgba(0, 104, 55, 0.1) !important;
            transition: all 0.3s ease !important;
        }
        
        .hamiz-entry-extractor-badge {
            position: absolute;
            top: -10px;
            right: -10px;
            background-color: #006837;
            color: white;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
            z-index: 1000;
            box-shadow: 0 2px 4px rgba(0,0,0,0.2);
        }
    `;
    document.head.appendChild(style);
    
    // مراقبة تغييرات DOM للنماذج الديناميكية
    const observer = new MutationObserver((mutations) => {
        mutations.forEach((mutation) => {
            if (mutation.type === 'childList') {
                // إعادة فحص الحقول عند إضافة عناصر جديدة
                setTimeout(() => {
                    highlightFormFields();
                }, 500);
            }
        });
    });
    
    // بدء مراقبة التغييرات
    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
    
    // تمييز حقول النموذج
    function highlightFormFields() {
        // إزالة التمييز السابق
        document.querySelectorAll('.hamiz-entry-extractor-highlight').forEach(el => {
            el.classList.remove('hamiz-entry-extractor-highlight');
            const badge = el.querySelector('.hamiz-entry-extractor-badge');
            if (badge) badge.remove();
        });
        
        let fieldCount = 0;
        
        // تمييز الحقول بـ data-params
        document.querySelectorAll('[data-params*="entry."]').forEach((element, index) => {
            if (!element.classList.contains('hamiz-entry-extractor-highlight')) {
                element.classList.add('hamiz-entry-extractor-highlight');
                element.style.position = 'relative';
                
                const badge = document.createElement('div');
                badge.className = 'hamiz-entry-extractor-badge';
                badge.textContent = `Entry ${++fieldCount}`;
                element.appendChild(badge);
            }
        });
        
        // تمييز الحقول بـ name attributes
        document.querySelectorAll('[name^="entry."]').forEach((element, index) => {
            const parent = element.closest('[role="listitem"], .freebirdFormviewerViewItemsItemItem');
            if (parent && !parent.classList.contains('hamiz-entry-extractor-highlight')) {
                parent.classList.add('hamiz-entry-extractor-highlight');
                parent.style.position = 'relative';
                
                const badge = document.createElement('div');
                badge.className = 'hamiz-entry-extractor-badge';
                badge.textContent = `Entry ${++fieldCount}`;
                parent.appendChild(badge);
            }
        });
    }
    
    // تشغيل التمييز عند تحميل الصفحة
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', highlightFormFields);
    } else {
        highlightFormFields();
    }
    
    // إعادة تشغيل التمييز عند تغيير الصفحة (للـ SPA)
    let currentUrl = location.href;
    new MutationObserver(() => {
        if (location.href !== currentUrl) {
            currentUrl = location.href;
            setTimeout(highlightFormFields, 1000);
        }
    }).observe(document, { subtree: true, childList: true });
    
    // إضافة رسائل الكونسول للمطورين
    console.log('%c🚀 حميز نت - مستخرج Entry IDs نشط', 'color: #006837; font-size: 16px; font-weight: bold;');
    console.log('%c📋 تم تحميل سكريبت الاستخراج بنجاح', 'color: #008542; font-size: 12px;');
})();